<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\CitiesController;
use App\Http\Controllers\userMobileController;
use App\Http\Controllers\UsersController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/auth/register', [AuthController::class, 'createUser'])->name('register');
Route::post('/auth/login', [AuthController::class, 'loginUser'])->name('login');
Route::get('/auth/login', [AuthController::class, 'loginUser'])->name('login');




Route::get('cities', [CitiesController::class, 'cities'])->name('city.cities');
Route::get('countries/{country}/{city}', [CitiesController::class, 'countries'])->name('city.countries');

Route::get('vechile-search', [CitiesController::class, 'vechileSearch'])->name('city.vechile_search');
Route::post('booking', [CitiesController::class, 'booking'])->name('booking');
Route::get('get-booking-detail', [CitiesController::class, 'getBookingDetails'])->name('booking.get-booking-detail');
Route::get('to-cities', [CitiesController::class, 'toCities'])->name('city.to_cities');

Route::post('otp-generate', [userMobileController::class, 'GenerateOTP'])->name('otp');
Route::post('otp-verification', [userMobileController::class, 'Otpverification'])->name('mobile-otp');

Route::post('response', [userMobileController::class, 'response'])->name('response');
Route::get('getBookingStatus/{booking_id}', [userMobileController::class, 'getBookingStatus'])->name('getBookingStatus');

Route::middleware('auth:sanctum')->group(function () {
    Route::post('logout', [AuthController::class, 'logout']);
    Route::get('testing', [AuthController::class, 'testing'])->name('api.testing');

    //User api
    Route::get('get-auth-user', [UsersController::class, 'getAuthUser'])->name('api.get_auth_user');
    Route::post('update-user', [UsersController::class, 'updateUser'])->name('api.update_user');

    //Coupon
    Route::post('verify-coupon', [UsersController::class, 'verifyCoupon'])->name('coupon.verify');

    
});

