<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Lark Holidays APIs</title>

    <!-- Fonts -->
    <link href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js"
        integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-Fy6S3B9q64WdZWQUiU+q4/2Lc9npb8tCaSX9FK7E8HnRr0Jz8D6OP9dO5Vg3Q9ct" crossorigin="anonymous">
    </script>
    <!-- Styles -->
    <style>
    /*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */
        html {
            line-height: 1.15;
            -webkit-text-size-adjust: 100%
        }

        body {
            margin: 0;
            font-family: 'Nunito', sans-serif;
        }
    </style>
    
</head>
<body class="d-flex justify-content-center">
    @if (env('MACHINE') == 'development')
    <div class="card text-center" id="main_card">
        @if(@$message)
        <div class="alert alert-success">
            <strong>Success!</strong> {!! $message !!}
        </div>
        @endif
        <div class="card-header bg-warning">
            <b>Welcome to lark Holidays</b>
        </div>
        <div class="card-body">
            <h5 class="card-title">API Need Thing</h5>
            <p class="card-text">Below buttons are to used configure the applications</p>
            <a href="{{url('route-migration')}}" class="btn btn-primary">MIGRATE DB</a>
            <a href="{{url('route-seed')}}" class="btn btn-secondary">SEED DB</a>
            <a href="{{url('api/documentation')}}" class="btn btn-success">APIs</a>
            <a href="swagger-update" class="btn btn-danger">SWAGGER UPDATE</a>
        </div>
        <div class="card-footer text-muted"></div>
    </div>
    <script>
        var auth = sessionStorage.getItem("lark_holiday")
        if (!auth) {
            document.getElementById('main_card').style.display  = 'none'
            let text;
            let password_key = prompt("Please enter your password key:");
            if (password_key == null || password_key == "") {
                text = "";
            } else {
                text = password_key;
            }
            if (password_key == 'Admin123') {
                sessionStorage.setItem("lark_holiday", true)
                document.getElementById('main_card').style.display  = ''
            }
        }
    </script>
    @endif
</body>
</html>