<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('gender', ['male', 'female', 'other'])->after('password');
            $table->string('city')->nullable()->after('gender'); // Set city as nullable
            $table->string('state')->nullable()->after('gender'); // Set state as nullable
            $table->string('country')->nullable()->after('gender'); // Set country as nullable
            $table->text('address')->nullable()->after('gender'); // Set address as nullable
            $table->string('mobile')->unique()->nullable()->after('gender'); // Set mobile as nullable
            $table->string('pincode')->nullable()->after('gender'); // Set pincode as nullable
            $table->date('dob')->nullable()->after('gender'); // Set DOB as nullable
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Schema::table('users', function (Blueprint $table) {
        //     $table->dropColumn('cust_id');
        // }); 
    }
};
