<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transfer_booking', function (Blueprint $table) {
            $table->id();
            $table->integer('routes_with_price_id')->nullable();
            $table->integer('from')->nullable();
            $table->integer('to')->nullable();
            $table->string('from_pickup')->nullable();
            $table->string('to_drop')->nullable();
            $table->string('from_lat')->nullable();
            $table->string('to_lat')->nullable();
            $table->date('date')->nullable();
            $table->integer('adult')->nullable();
            $table->integer('child')->nullable();
            $table->integer('infint')->nullable();
            $table->integer('is_comfirm')->nullable();
            $table->integer('supplier_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfer_booking');
    }
};
