<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\TransferBooking;
use App\Models\OtpModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class userMobileController extends Controller
{

    /**
     * @OA\Post(
     *   path="/api/otp-generate",
     *   tags={"Mobile with customer"},
     *   summary="Generate OTP New User OR Old User",
     *   description="It will return an OTP and customer type",
     *   operationId="otpGeneration",       
     *   @OA\RequestBody(
     *       required=true,
     *       @OA\MediaType(
     *           mediaType="application/json",
     *           @OA\Schema(
     *               @OA\Property(property="mobile", type="string", example="900000"),
     *           )
     *       )
     *   ),
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     *
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function GenerateOTP(Request $request)
    {
        // Validate request data
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|min:9'
        ]);
        // Return errors if validation error occur.
        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json([
                'error' => $errors
            ], 400);
        }
        // Check if validation pass then create user and auth token. Return the auth token
        if ($validator->passes()) {
            $mobileExist = User::where('mobile', $request->mobile)->first();
            
            $response = [];
            $booking_id = $request->id;
            if ($mobileExist) { // Check if mobile number exists
                $response['customer_type'] = (@$mobileExist->name && @$mobileExist->email) ? 'old' : 'new';
                $cust_id = $mobileExist->id;
            } else {
                // $data = new User(); // Initialize the $data variable with a new instance of User
                // $data->mobile = $request->mobile;
                // $data->save();
                $data = User::create(['mobile' => $request->mobile, 'name' =>  '', 'email' => '', 'password' => '']);
                
                $response['customer_type'] = 'new';
                $cust_id = $data->id;
            }
            $otp = rand(100000, 999999);
            $response['otp_generated_at'] = now();
            $response['otp'] = $otp;
            $response['cust_id'] = $cust_id;
            $check_otp = OtpModel::where('cust_id', $cust_id)->first();
            if (@$check_otp) {
                $check_otp->update(['otp_code' => $otp]);
            } else {
                OtpModel::create(['cust_id' => $cust_id, 'otp_code' => $otp]);
            }
            $this->updateCustID($booking_id,$cust_id);
            return response()->json([
                'data' => @$response,
                'status' => 'OTP send successfully',
            ]);
        }
        
    }
    
    function updateCustID($booking_id,$cust_id){
        TransferBooking::where('id', $booking_id)->update(['cust_id' => $cust_id]);
    }


    public function payment($id)
    {
        $data = TransferBooking::find($id);
        $cust_id = $data->cust_id;
        $price = round($data->price).'00';
        $row_id = $data->id;
        //echo json_encode($cust_id);
        //$price = '000000000100';
        $newprice = str_pad($price, 12, '0', STR_PAD_LEFT);
        $booking_id = 'LARK-T-'.str_pad($row_id, 5, '0', STR_PAD_LEFT);
        return view('2c2p',['amt'=>$newprice,'cust_id'=>$cust_id,'row_id'=>$row_id,'booking_id'=>$row_id]);
        
        //{"id":48,"routes_with_price_id":"2","from":"2","to":"3","from_pickup":"sengamedu","to_drop":"sirkali","from_lat":null,"to_lat":null,"date":"2023-08-29","adult":"2","child":"2","infint":"2","is_comfirm":null,"supplier_id":null,"created_at":"2023-08-29T11:41:25.000000Z","updated_at":"2023-08-29T11:41:47.000000Z","pickup_point":null,"airport_id":null,"no_of_luggage":null,"flight_no":null,"flight_name":null,"arrival_time":null,"pickup_time":null,"price":"599.00","cust_id":"2"}
    }
    
    public function response()
    {
        $response = file_get_contents('php://input');
        echo "Response:<br/><textarea style='width:100%;height:80px'>".$response."</textarea>"; 
    
        //each response params:
        $version = $_REQUEST["version"];
        $request_timestamp = $_REQUEST["request_timestamp"];
        $merchant_id = $_REQUEST["merchant_id"];
        $currency = $_REQUEST["currency"];
        $order_id = $_REQUEST["order_id"];
        $amount = $_REQUEST["amount"];
        $invoice_no = $_REQUEST["invoice_no"];
        $transaction_ref = $_REQUEST["transaction_ref"];
        $approval_code = $_REQUEST["approval_code"];
        $eci = $_REQUEST["eci"];
        $transaction_datetime = $_REQUEST["transaction_datetime"];
        $payment_channel = $_REQUEST["payment_channel"];
        $payment_status = $_REQUEST["payment_status"];
        $channel_response_code = $_REQUEST["channel_response_code"];
        $channel_response_desc = $_REQUEST["channel_response_desc"];
        $masked_pan = $_REQUEST["masked_pan"];
        $stored_card_unique_id = $_REQUEST["stored_card_unique_id"];
        $backend_invoice = $_REQUEST["backend_invoice"];
        $paid_channel = ((isset($_REQUEST["paid_channel"]))?$_REQUEST["paid_channel"]:'');
        $recurring_unique_id = $_REQUEST["recurring_unique_id"];
        $paid_agent = ((isset($_REQUEST["paid_agent"]))?$_REQUEST["paid_agent"]:'');
        $payment_scheme = $_REQUEST["payment_scheme"];
        $user_defined_1 = $_REQUEST["user_defined_1"];
        $user_defined_2 = $_REQUEST["user_defined_2"];
        $user_defined_3 = $_REQUEST["user_defined_3"];
        $user_defined_4 = $_REQUEST["user_defined_4"];
        $user_defined_5 = $_REQUEST["user_defined_5"];
        $browser_info = $_REQUEST["browser_info"];
        $ippPeriod = $_REQUEST["ippPeriod"];
        $ippInterestType = $_REQUEST["ippInterestType"];
        $ippInterestRate = $_REQUEST["ippInterestRate"];
        $ippMerchantAbsorbRate = $_REQUEST["ippMerchantAbsorbRate"];
        $payment_scheme = $_REQUEST["payment_scheme"];
        $process_by = $_REQUEST["process_by"];
        $sub_merchant_list = $_REQUEST["sub_merchant_list"];
        $hash_value = $_REQUEST["hash_value"];   
       
        
        //check response hash value (for security, hash value validation is Mandatory)
        $checkHashStr = $version . $request_timestamp . $merchant_id . $order_id . 
        $invoice_no . $currency . $amount . $transaction_ref . $approval_code . 
        $eci . $transaction_datetime . $payment_channel . $payment_status . 
        $channel_response_code . $channel_response_desc . $masked_pan . 
        $stored_card_unique_id . $backend_invoice . $paid_channel . $paid_agent . 
        $recurring_unique_id . $user_defined_1 . $user_defined_2 . $user_defined_3 . 
        $user_defined_4 . $user_defined_5 . $browser_info . $ippPeriod . 
        $ippInterestType . $ippInterestRate . $ippMerchantAbsorbRate . $payment_scheme .
        $process_by . $sub_merchant_list;
          
        $SECRETKEY = "7CA438111FDE3D384638B837A72F8E32684CDBEE522C6AA00F0E1ED2E2A5B4F2";
        $checkHash = hash_hmac('sha256',$checkHashStr, $SECRETKEY,false); 
        echo "checkHash: ".$checkHash."<br/><br/>";
    
        if(strcmp(strtolower($hash_value), strtolower($checkHash))==0){
            echo "Hash check = success. it is safe to use this response data.";
            if($channel_response_desc=='Approved'){
                TransferBooking::where('id', $order_id)->update(['is_comfirm' => 1]);
                $this->whastapp_aisensy($order_id);
            }
        }
        
        else{
            echo "Hash check = failed. do not use this response data.";
        }
        return redirect('http://larktransports.co/BookingConfirmed/'.$order_id);
    }
    
    
    public function getBookingStatus($booking_id){
        $data = TransferBooking::where('id',$booking_id)->first();
        return response()->json($data);
    }
    
    
    function whastapp_aisensy($booking_id)
    {
        
        $data = TransferBooking::where('id',$booking_id)->first();
        
        $pax =  $data->adult+$data->child+$data->infint;
        
        $pickup =  $data->from_pickup;

        $drop = $data->to_drop;
        $cust_id = $data->cust_id;
        $user = User::where('id', $cust_id)->first();
        $mobile = $user->mobile;
        
        $date =  date('d-m-Y', strtotime($data->date));
        
        $booking_id_new = 'LARK-T-'.str_pad($booking_id, 5, '0', STR_PAD_LEFT);
        
        $ch = curl_init();
        $headers  = [
            'Content-Type: application/json'
        ];
        $postData = [
            'apiKey' => 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjYzYmJlMDg0MGQ5NTdhNzFmZDQ2OTVlNCIsIm5hbWUiOiJMYXJrIEhvbGlkYXlzIENvLiwgTHRkIiwiYXBwTmFtZSI6IkFpU2Vuc3kiLCJjbGllbnRJZCI6IjYzYmJlMDg0MGQ5NTdhNzFmZDQ2OTVkZiIsImFjdGl2ZVBsYW4iOiJCQVNJQ19NT05USExZIiwiaWF0IjoxNjczMjU3MDkyfQ.gZ1wJh0nFZ5_DDZIrko4itAh5mhqY6O1r1QQww9j5pc',
            'campaignName' => 'transprt',
            'destination' => $mobile,
            'userName' => 'test',
            'templateParams' => array($date, '10:00 Hrs', $drop, $pickup,$pax.' Pax',$booking_id_new),
        ];
        curl_setopt($ch, CURLOPT_URL, "https://backend.aisensy.com/campaign/t1/api");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $result     = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);


        $postData['response'] = $result;

    
    
        echo json_encode($postData);

    
    }
    
    /**
     * @OA\Post(
     *   path="/api/otp-verification",
     *   tags={"Mobile with customer"},
     *   summary="To check Opt if it's new customer then store the name and email",
     *   description="It will return token",
     *   operationId="otpVerify",       
     *   @OA\RequestBody(
     *       @OA\MediaType(
     *           mediaType="application/json",
     *           @OA\Schema(
     *               @OA\Property(property="cust_id", type="string", example="",),
     *               @OA\Property(property="otp", type="string", example=""),
     *               @OA\Property(property="mobile", type="string", example="900000"),
     *               @OA\Property(property="name", type="string", example=""),
     *               @OA\Property(property="email", type="string", example=""),
     *           )
     *       )
     *   ),
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     *
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function Otpverification(Request $request)
    {
        // Validate request data
        $validator = Validator::make($request->all(), [
            'cust_id' => 'required',
            'mobile' => 'required|min:9',
            'otp' => 'required|numeric',
        ]);
        // Return errors if validation error occur.
        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json([
                'error' => $errors
            ], 422);
        }

        if ($validator->passes()) {
            $check_otp = OtpModel::where(['cust_id' => $request->cust_id, 'otp_code' => $request->otp])->first();
            if (@$check_otp) {
                $user = User::where('id', $request->cust_id)->firstOrFail();
                $data['token'] = $user->createToken('auth_token')->plainTextToken;
                $data['token_type'] = 'Bearer';
                if (@$request->name && @$request->email) {
                    $user->update(['name' => $request->name, 'email' => $request->email]);
                }
                $data['status'] = "Authentication success";
                $check_otp->delete();
            } else {
                $data['status'] = "OTP is invalid";
            }
            return response()->json($data);
        }
    }


}
