<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transfer_booking', function (Blueprint $table) {
            $table->integer('pickup_point')->nullable();
            $table->integer('airport_id')->nullable();
            $table->integer('no_of_luggage')->nullable();
            $table->string('flight_no')->nullable();
            $table->string('flight_name')->nullable();
            $table->time('arrival_time')->nullable();
            $table->time('pickup_time')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transfer_booking', function (Blueprint $table) {
            $table->dropColumn('pickup_point');
            $table->dropColumn('airport_id');
            $table->dropColumn('no_of_luggage');
            $table->dropColumn('flight_no');
            $table->dropColumn('flight_name');
            $table->dropColumn('arrival_time');
            $table->dropColumn('pickup_time');

        });
    }
};
